/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import edu.princeton.swing.text.HighlightedDocument;
import edu.princeton.toy.lang.TVirtualMachine;
import edu.princeton.toy.lang.TWord;
import edu.princeton.toy.lang.TWordBuffer;

public class TProgramDocument
extends HighlightedDocument {
    public static final int MAX_WARNINGS = 30;
    public static final byte STYLE_IDENTIFIER = 0;
    public static final byte STYLE_INSTRUCTION = 1;
    public static final byte STYLE_KEYWORD = 2;
    public static final byte STYLE_COMMENT = 3;
    public static final byte STYLE_AUTO_COMMENT = 4;
    public static final byte STYLE_OUTSIDE_MARGIN = 5;
    public static final String DEFAULT_TITLE = "Untitled";
    public static final String HEADER_BAR = "// -----------------------------------------------------------------------------";
    public static final int COMMENT_COLUMN = 41;
    public static final int OUTSIDE_MARGIN_COLUMN = 80;
    private static final TWordBuffer EMPTY_BUFFER = new TWordBuffer();
    private static int untitledCtr = 1;
    private String title;
    private TWordBuffer initialStdin = new TWordBuffer();
    private TWord[] initialMem = new TWord[256];
    private int[] lineDefined = new int[256];

    public TProgramDocument() {
        this("/******************************************************************************\n *  Description:\n *  Input:\n *  Output:\n ******************************************************************************/");
        ++untitledCtr;
    }

    public TProgramDocument(String text) {
        this.setText(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineDefined(int address, boolean returnLastLine) {
        int answer;
        if (address < 0 || address >= 256) {
            throw new ArrayIndexOutOfBoundsException();
        }
        try {
            this.readLock();
            answer = this.lineDefined[address];
            if (answer == -1 && returnLastLine) {
                answer = this.lineCount - 1;
            }
        }
        finally {
            this.readUnlock();
        }
        return answer;
    }

    public WarningInfoStruct getWarnings(boolean ignoreWarnings) {
        return this.getWarnings(null, ignoreWarnings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WarningInfoStruct getWarnings(WarningInfoStruct warningInfo, boolean ignoreWarnings) {
        if (warningInfo == null) {
            warningInfo = new WarningInfoStruct();
        }
        boolean hasFatalError = false;
        String[] warnings = warningInfo.warnings;
        int[] selectionStart = warningInfo.selectionStart;
        int[] selectionEnd = warningInfo.selectionEnd;
        int warningCount = 0;
        try {
            this.readLock();
            int previousAddress = -1;
            boolean functionEncountered = false;
            for (int lineCtr = 0; !hasFatalError && lineCtr < this.lineCount && warningCount <= 30; ++lineCtr) {
                int address;
                int charCtr = this.lineOffsets[lineCtr];
                int lineLength = lineCtr == this.lineCount - 1 ? this.charCount - charCtr : this.lineOffsets[lineCtr + 1] - charCtr - 1;
                if (TWord.isHexDigit(this.chars[charCtr]) && charCtr + 7 < this.charCount && TWord.isHexDigit(this.chars[charCtr + 1]) && this.chars[charCtr + 2] == ':' && this.chars[charCtr + 3] == ' ' && TWord.isHexDigit(this.chars[charCtr + 4]) && TWord.isHexDigit(this.chars[charCtr + 5]) && TWord.isHexDigit(this.chars[charCtr + 6]) && TWord.isHexDigit(this.chars[charCtr + 7])) {
                    address = TWord.hexDigitToInt(this.chars[charCtr]) << 4 | TWord.hexDigitToInt(this.chars[charCtr + 1]);
                    int op = TWord.hexDigitToInt(this.chars[charCtr + 4]);
                    int d = TWord.hexDigitToInt(this.chars[charCtr + 5]);
                    int s = TWord.hexDigitToInt(this.chars[charCtr + 6]);
                    int t = TWord.hexDigitToInt(this.chars[charCtr + 7]);
                    int imm = s << 4 | t;
                    short instruction = (short)(op << 12 | d << 8 | s << 4 | t);
                    if (previousAddress >= address) {
                        if (this.initialMem[address].isInitialized()) {
                            selectionStart[warningCount] = charCtr;
                            selectionEnd[warningCount] = charCtr + 8;
                            warnings[warningCount] = "Fatal error at " + TWord.HEX_PAIRS[address] + ":\n" + "This address location has already been defined.  Please " + "renumber your lines appropriately.\n";
                            hasFatalError = true;
                            ++warningCount;
                        } else {
                            selectionStart[warningCount] = charCtr;
                            selectionEnd[warningCount] = charCtr + 8;
                            warnings[warningCount] = "Fatal error at " + TWord.HEX_PAIRS[address] + ":\n" + "This address location is out of order.  Please renumber your " + "lines appropriately.\n";
                            hasFatalError = true;
                            ++warningCount;
                        }
                    }
                    if (!hasFatalError && !ignoreWarnings && warningCount <= 30 && address >= 16) {
                        if (!this.initialMem[16].isInitialized() && address > 16 && previousAddress < 16 && warningCount <= 30) {
                            selectionStart[warningCount] = charCtr;
                            selectionEnd[warningCount] = charCtr + 8;
                            warnings[warningCount] = "Warning at 10:\nThe line 0x10 must be defined if your program is to run at all.  Please renumber your lines appropriately.\n";
                            ++warningCount;
                        }
                        if (address == 255 && warningCount <= 30) {
                            selectionStart[warningCount] = charCtr;
                            selectionEnd[warningCount] = charCtr + 8;
                            warnings[warningCount] = "Warning at FF:\nMemory location FF is reserved for input and output operations.  You may not be able to access this data.\n";
                            ++warningCount;
                        }
                        if (address > previousAddress + 1 && previousAddress >= 16 && !functionEncountered && warningCount <= 30) {
                            if (address == previousAddress + 2) {
                                selectionStart[warningCount] = charCtr;
                                selectionEnd[warningCount] = charCtr + 8;
                                warnings[warningCount] = "Warning between " + TWord.HEX_PAIRS[previousAddress] + " and " + TWord.HEX_PAIRS[address] + ":\n" + "There is no definition of line " + TWord.HEX_PAIRS[address - 1] + ".  Note that this may not be a fatal error, it may be " + "the space between functions.  If this really is the space " + "between functions, please leave a function comment " + "(Tools:: Insert Function Comment).\n";
                                ++warningCount;
                            } else {
                                selectionStart[warningCount] = charCtr;
                                selectionEnd[warningCount] = charCtr + 8;
                                warnings[warningCount] = "Warning between " + TWord.HEX_PAIRS[previousAddress] + " and " + TWord.HEX_PAIRS[address] + ":\n" + "There are undefined lines.  Note that this may not be a " + "fatal error, it may be the space between functions.  If " + "this really is the space between functions, please leave a " + "function comment (Tools:: Insert Function Comment).\n";
                                ++warningCount;
                            }
                        }
                        if (d == 0 && (op >= 1 && op <= 8 || op == 10 || op == 15) && instruction != 4096 && warningCount <= 30) {
                            selectionStart[warningCount] = charCtr;
                            selectionEnd[warningCount] = charCtr + 8;
                            warnings[warningCount] = "Warning at " + TWord.HEX_PAIRS[address] + ":\n" + "R[0] is a constant.  It should not be the destination of any " + "instruction with the exception of nop.\n";
                            ++warningCount;
                        }
                        if (op == 0 && (d != 0 || s != 0 || t != 0) && warningCount <= 30) {
                            selectionStart[warningCount] = charCtr;
                            selectionEnd[warningCount] = charCtr + 8;
                            warnings[warningCount] = "Warning at " + TWord.HEX_PAIRS[address] + ":\n" + "Operator 0 (halt) does not require a 'd', 's', or 't'.  It is " + "conventional to halt a program with \"0000\".\n";
                            ++warningCount;
                        }
                        if (op == 10 && s != 0 && warningCount <= 30) {
                            selectionStart[warningCount] = charCtr;
                            selectionEnd[warningCount] = charCtr + 8;
                            warnings[warningCount] = "Warning at " + TWord.HEX_PAIRS[address] + ":\n" + "Operator A (load indirect) does not require an 's'.  It is " + "conventional to assign the 3rd digit to '0'.\n";
                            ++warningCount;
                        }
                        if (op == 11 && s != 0 && warningCount <= 30) {
                            selectionStart[warningCount] = charCtr;
                            selectionEnd[warningCount] = charCtr + 8;
                            warnings[warningCount] = "Warning at " + TWord.HEX_PAIRS[address] + ":\n" + "Operator B (store indirect) does not require an 's'.  It is " + "conventional to assign the 3rd digit to '0'.\n";
                            ++warningCount;
                        }
                        if (op == 14 && (s != 0 || t != 0) && warningCount <= 30) {
                            selectionStart[warningCount] = charCtr;
                            selectionEnd[warningCount] = charCtr + 8;
                            warnings[warningCount] = "Warning at " + TWord.HEX_PAIRS[address] + ":\n" + "Operator E (jump register) does not require an 's' or 't'.  It " + "is conventional to terminate such a command with two '0's.\n";
                            ++warningCount;
                        }
                        if (op == 15 && imm == address && warningCount <= 30) {
                            selectionStart[warningCount] = charCtr;
                            selectionEnd[warningCount] = charCtr + 8;
                            warnings[warningCount] = "Warning at " + TWord.HEX_PAIRS[address] + ":\n" + "This command is an infinite loop.\n";
                            ++warningCount;
                        }
                        if ((op == 12 || op == 13) && imm == address && warningCount <= 30) {
                            selectionStart[warningCount] = charCtr;
                            selectionEnd[warningCount] = charCtr + 8;
                            warnings[warningCount] = "Warning at " + TWord.HEX_PAIRS[address] + ":\n" + "This command could be an infinite loop.\n";
                            ++warningCount;
                        }
                        if ((op == 12 || op == 13) && imm == address + 1 && warningCount <= 30) {
                            selectionStart[warningCount] = charCtr;
                            selectionEnd[warningCount] = charCtr + 8;
                            warnings[warningCount] = "Warning at " + TWord.HEX_PAIRS[address] + ":\n" + "This is a command to jump to the next line.  In other words, " + "this line appears to serve no purpose.\n";
                            ++warningCount;
                        }
                        if (op == 13 && d == 0 && warningCount <= 30) {
                            selectionStart[warningCount] = charCtr;
                            selectionEnd[warningCount] = charCtr + 8;
                            warnings[warningCount] = "Warning at " + TWord.HEX_PAIRS[address] + ":\n" + "Operator D (branch positive) will not branch since  R[0] is " + "always 0.  In other words, his line appears to serve no " + "purpose.\n";
                            ++warningCount;
                        }
                        if ((op == 1 || op == 3) && (d == s && t == 0 || d == t && s == 0) && instruction != 4096 && warningCount <= 30 || op == 2 && d == s && t == 0 && warningCount <= 30) {
                            selectionStart[warningCount] = charCtr;
                            selectionEnd[warningCount] = charCtr + 8;
                            warnings[warningCount] = "Warning at " + TWord.HEX_PAIRS[address] + ":\n" + "This command will not change R[" + TWord.HEX_DIGITS[d] + "] because R[0] is always 0.  In other words, this line appears " + "to serve no purpose.\n";
                            ++warningCount;
                        }
                        if (op == 4 && d == s && t == 0 && warningCount <= 30 || (op == 5 || op == 6) && d == s && t == 0 && warningCount <= 30) {
                            selectionStart[warningCount] = charCtr;
                            selectionEnd[warningCount] = charCtr + 8;
                            warnings[warningCount] = "Warning at " + TWord.HEX_PAIRS[address] + ":\n" + "This command will not change R[" + TWord.HEX_DIGITS[d] + "].  In other words, this line appears to serve no purpose.\n";
                            ++warningCount;
                        }
                    }
                    previousAddress = address;
                    functionEncountered = false;
                    continue;
                }
                if (!(this.chars[charCtr] != 'f' && this.chars[charCtr] != 'F' || charCtr + 7 >= this.charCount || this.chars[charCtr + 1] != 'u' && this.chars[charCtr + 1] != 'U' || this.chars[charCtr + 2] != 'n' && this.chars[charCtr + 2] != 'N' || this.chars[charCtr + 3] != 'c' && this.chars[charCtr + 3] != 'C' || this.chars[charCtr + 4] != 't' && this.chars[charCtr + 4] != 'T' || this.chars[charCtr + 5] != 'i' && this.chars[charCtr + 5] != 'I' || this.chars[charCtr + 6] != 'o' && this.chars[charCtr + 6] != 'O' || this.chars[charCtr + 7] != 'n' && this.chars[charCtr + 7] != 'N' || charCtr + 8 != this.charCount && this.chars[charCtr + 8] != ' ' && this.chars[charCtr + 8] != '\n')) {
                    functionEncountered = true;
                    continue;
                }
                if (!TWord.isHexDigit(this.chars[charCtr])) continue;
                address = TWord.hexDigitToInt(this.chars[charCtr]);
                int peekCtr = charCtr + 1;
                boolean isProblem = true;
                if (isProblem && peekCtr < this.charCount) {
                    if (this.chars[peekCtr] == ':') {
                        ++peekCtr;
                    } else if (peekCtr + 1 < this.charCount && TWord.isHexDigit(this.chars[peekCtr]) && this.chars[peekCtr + 1] == ':') {
                        address = address << 4 | TWord.hexDigitToInt(this.chars[peekCtr]);
                        peekCtr += 2;
                    } else {
                        isProblem = false;
                    }
                }
                if (!isProblem || peekCtr >= this.charCount) continue;
                while (peekCtr < this.charCount && (this.chars[peekCtr] == ' ' || this.chars[peekCtr] == '\n')) {
                    ++peekCtr;
                }
                if (peekCtr >= this.charCount || !TWord.isHexDigit(this.chars[peekCtr])) continue;
                int instruction = TWord.hexDigitToInt(this.chars[peekCtr]);
                if (++peekCtr < this.charCount && TWord.isHexDigit(this.chars[peekCtr])) {
                    instruction = instruction << 4 | TWord.hexDigitToInt(this.chars[peekCtr]);
                    ++peekCtr;
                }
                if (peekCtr < this.charCount && TWord.isHexDigit(this.chars[peekCtr])) {
                    instruction = instruction << 4 | TWord.hexDigitToInt(this.chars[peekCtr]);
                    ++peekCtr;
                }
                if (peekCtr < this.charCount && TWord.isHexDigit(this.chars[peekCtr])) {
                    instruction = instruction << 4 | TWord.hexDigitToInt(this.chars[peekCtr]);
                }
                selectionStart[warningCount] = charCtr;
                selectionEnd[warningCount] = ++peekCtr;
                warnings[warningCount] = "Warning at " + TWord.HEX_PAIRS[address] + ": " + "Did you mean \"" + TWord.HEX_PAIRS[address] + ": " + TWord.getWord((short)instruction).toHexString(false) + "\" instead of \"" + TWord.HEX_PAIRS[address] + ":" + TWord.getWord((short)instruction).toHexString(false) + "\"?";
                hasFatalError = false;
                ++warningCount;
            }
            if (previousAddress < 16 && !ignoreWarnings && warningCount < 30) {
                selectionStart[warningCount] = this.charCount;
                selectionEnd[warningCount] = this.charCount;
                warnings[warningCount] = "Warning at 10:\nThe line 0x10 must be defined if your program is to run at all.  Please renumber your lines appropriately.\n";
                ++warningCount;
            }
            if (!hasFatalError && warningCount == 31) {
                selectionStart[30] = 0;
                selectionEnd[30] = 0;
                warnings[30] = "Fatal error:\nYour program has more than 30 warnings.  Please resolve these warnings before proceeding.  If you wish to proceed anyway, turn on the \"Ignore Warnings\" option.\n";
                hasFatalError = true;
            }
        }
        finally {
            this.readUnlock();
        }
        warningInfo.hasFatalError = hasFatalError;
        warningInfo.warningCount = warningCount;
        return warningInfo;
    }

    public TWordBuffer getInitialStdin() {
        return (TWordBuffer)this.initialStdin.clone();
    }

    public TWordBuffer getInitialStdin(TWordBuffer buffer) {
        buffer.clear();
        buffer.add(this.initialStdin);
        return buffer;
    }

    public void setInitialStdin(TWordBuffer initialStdin) {
        if (initialStdin == null) {
            throw new NullPointerException();
        }
        this.initialStdin.clear();
        this.initialStdin.add(initialStdin);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void reset(TVirtualMachine virtualMachine) {
        virtualMachine.reset();
        virtualMachine.initMem(this.initialMem);
        virtualMachine.setStdin(EMPTY_BUFFER, this.initialStdin);
    }

    @Override
    public int getStyleCount() {
        return 6;
    }

    @Override
    public int getTabSize() {
        return 4;
    }

    @Override
    public void assignStyles() {
        int ctr;
        int previousAddress = -1;
        boolean functionEncountered = false;
        String title = null;
        for (ctr = 0; ctr < 256; ++ctr) {
            this.initialMem[ctr] = TWord.UNINITIALIZED_VALUE;
            this.lineDefined[ctr] = -1;
        }
        for (ctr = 0; ctr < this.charCount; ++ctr) {
            this.charStyles[ctr] = 3;
        }
        for (int lineCtr = 0; lineCtr < this.lineCount; ++lineCtr) {
            int ctr2;
            int charCtr = this.lineOffsets[lineCtr];
            int lineLength = lineCtr == this.lineCount - 1 ? this.charCount - charCtr : this.lineOffsets[lineCtr + 1] - charCtr - 1;
            if (TWord.isHexDigit(this.chars[charCtr]) && charCtr + 7 < this.charCount && TWord.isHexDigit(this.chars[charCtr + 1]) && this.chars[charCtr + 2] == ':' && this.chars[charCtr + 3] == ' ' && TWord.isHexDigit(this.chars[charCtr + 4]) && TWord.isHexDigit(this.chars[charCtr + 5]) && TWord.isHexDigit(this.chars[charCtr + 6]) && TWord.isHexDigit(this.chars[charCtr + 7])) {
                int ctr3;
                int address = TWord.hexDigitToInt(this.chars[charCtr]) << 4 | TWord.hexDigitToInt(this.chars[charCtr + 1]);
                int op = TWord.hexDigitToInt(this.chars[charCtr + 4]);
                int d = TWord.hexDigitToInt(this.chars[charCtr + 5]);
                int s = TWord.hexDigitToInt(this.chars[charCtr + 6]);
                int t = TWord.hexDigitToInt(this.chars[charCtr + 7]);
                int imm = s << 4 | t;
                short instruction = (short)(op << 12 | d << 8 | s << 4 | t);
                this.initialMem[address] = TWord.getWord(instruction);
                this.lineDefined[address] = lineCtr;
                previousAddress = address;
                for (ctr3 = 0; ctr3 < 8; ++ctr3) {
                    this.charStyles[charCtr + ctr3] = 1;
                }
                if (lineLength <= 41) {
                    for (ctr3 = 8; ctr3 < lineLength; ++ctr3) {
                        this.charStyles[charCtr + ctr3] = 4;
                    }
                    continue;
                }
                for (ctr3 = 8; ctr3 < 41; ++ctr3) {
                    this.charStyles[charCtr + ctr3] = 4;
                }
                if (lineLength <= 80) {
                    for (ctr3 = 41; ctr3 < lineLength; ++ctr3) {
                        this.charStyles[charCtr + ctr3] = 3;
                    }
                    continue;
                }
                for (ctr3 = 41; ctr3 < 80; ++ctr3) {
                    this.charStyles[charCtr + ctr3] = 3;
                }
                for (ctr3 = 80; ctr3 < lineLength; ++ctr3) {
                    this.charStyles[charCtr + ctr3] = 5;
                }
                continue;
            }
            if (!(this.chars[charCtr] != 'f' && this.chars[charCtr] != 'F' || charCtr + 7 >= this.charCount || this.chars[charCtr + 1] != 'u' && this.chars[charCtr + 1] != 'U' || this.chars[charCtr + 2] != 'n' && this.chars[charCtr + 2] != 'N' || this.chars[charCtr + 3] != 'c' && this.chars[charCtr + 3] != 'C' || this.chars[charCtr + 4] != 't' && this.chars[charCtr + 4] != 'T' || this.chars[charCtr + 5] != 'i' && this.chars[charCtr + 5] != 'I' || this.chars[charCtr + 6] != 'o' && this.chars[charCtr + 6] != 'O' || this.chars[charCtr + 7] != 'n' && this.chars[charCtr + 7] != 'N' || charCtr + 8 != this.charCount && this.chars[charCtr + 8] != ' ' && this.chars[charCtr + 8] != '\n')) {
                for (ctr2 = 0; ctr2 < 8; ++ctr2) {
                    this.charStyles[charCtr + ctr2] = 2;
                }
                if (lineLength <= 80) {
                    for (ctr2 = 8; ctr2 < lineLength; ++ctr2) {
                        this.charStyles[charCtr + ctr2] = 0;
                    }
                    continue;
                }
                for (ctr2 = 8; ctr2 < 80; ++ctr2) {
                    this.charStyles[charCtr + ctr2] = 0;
                }
                for (ctr2 = 80; ctr2 < lineLength; ++ctr2) {
                    this.charStyles[charCtr + ctr2] = 5;
                }
                continue;
            }
            if (!(this.chars[charCtr] != 'p' && this.chars[charCtr] != 'P' || charCtr + 6 >= this.charCount || this.chars[charCtr + 1] != 'r' && this.chars[charCtr + 1] != 'R' || this.chars[charCtr + 2] != 'o' && this.chars[charCtr + 2] != 'O' || this.chars[charCtr + 3] != 'g' && this.chars[charCtr + 3] != 'G' || this.chars[charCtr + 4] != 'r' && this.chars[charCtr + 4] != 'R' || this.chars[charCtr + 5] != 'a' && this.chars[charCtr + 5] != 'A' || this.chars[charCtr + 6] != 'm' && this.chars[charCtr + 6] != 'M' || charCtr + 7 != this.charCount && this.chars[charCtr + 7] != ' ' && this.chars[charCtr + 7] != '\n')) {
                if (lineLength - 8 > 0) {
                    title = new String(this.chars, charCtr + 8, lineLength - 8).trim();
                }
                for (ctr2 = 0; ctr2 < 7; ++ctr2) {
                    this.charStyles[charCtr + ctr2] = 2;
                }
                if (lineLength <= 80) {
                    for (ctr2 = 7; ctr2 < lineLength; ++ctr2) {
                        this.charStyles[charCtr + ctr2] = 0;
                    }
                    continue;
                }
                for (ctr2 = 7; ctr2 < 80; ++ctr2) {
                    this.charStyles[charCtr + ctr2] = 0;
                }
                for (ctr2 = 80; ctr2 < lineLength; ++ctr2) {
                    this.charStyles[charCtr + ctr2] = 5;
                }
                continue;
            }
            if (lineLength <= 80) {
                for (ctr2 = 0; ctr2 < lineLength; ++ctr2) {
                    this.charStyles[charCtr + ctr2] = 3;
                }
                continue;
            }
            for (ctr2 = 0; ctr2 < 80; ++ctr2) {
                this.charStyles[charCtr + ctr2] = 3;
            }
            for (ctr2 = 80; ctr2 < lineLength; ++ctr2) {
                this.charStyles[charCtr + ctr2] = 5;
            }
        }
        this.title = title == null ? DEFAULT_TITLE : title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autocomment() {
        int[] newPositions = null;
        StringBuffer buffer = null;
        try {
            this.readLock();
            newPositions = this.getPositionOffsets();
            int positionCount = newPositions.length;
            int[] oldPositions = new int[positionCount];
            for (int ctr = 0; ctr < positionCount; ++ctr) {
                oldPositions[ctr] = newPositions[ctr];
            }
            buffer = new StringBuffer(2 * this.charCount);
            StringBuffer buffer2 = new StringBuffer(2 * this.charCount);
            boolean programEncountered = false;
            int charCtr = 0;
            while (charCtr < this.charCount) {
                int peekCtr;
                if (TWord.isCommand(new String(this.chars, charCtr, 8))) {
                    int oldPosition;
                    int ctr;
                    int peekCtr2;
                    int address = TWord.hexDigitToInt(this.chars[charCtr]) << 4 | TWord.hexDigitToInt(this.chars[charCtr + 1]);
                    TWord command = TWord.getWord((short)(TWord.hexDigitToInt(this.chars[charCtr + 4]) << 12 | TWord.hexDigitToInt(this.chars[charCtr + 5]) << 8 | TWord.hexDigitToInt(this.chars[charCtr + 6]) << 4 | TWord.hexDigitToInt(this.chars[charCtr + 7])));
                    buffer.append(Character.toUpperCase(this.chars[charCtr]));
                    buffer.append(Character.toUpperCase(this.chars[charCtr + 1]));
                    buffer.append(": ");
                    buffer.append(Character.toUpperCase(this.chars[charCtr + 4]));
                    buffer.append(Character.toUpperCase(this.chars[charCtr + 5]));
                    buffer.append(Character.toUpperCase(this.chars[charCtr + 6]));
                    buffer.append(Character.toUpperCase(this.chars[charCtr + 7]));
                    boolean updateComment = false;
                    for (peekCtr2 = charCtr + 8; peekCtr2 < this.charCount && this.chars[peekCtr2] == ' '; ++peekCtr2) {
                    }
                    if (peekCtr2 == this.charCount) {
                        if (peekCtr2 - charCtr > 41) {
                            for (ctr = 0; ctr < positionCount; ++ctr) {
                                oldPosition = oldPositions[ctr];
                                if (oldPosition <= charCtr + 41) continue;
                                int n = ctr;
                                newPositions[n] = newPositions[n] - (oldPosition - charCtr - 41);
                            }
                        } else {
                            for (ctr = 0; ctr < positionCount; ++ctr) {
                                oldPosition = oldPositions[ctr];
                                if (oldPosition != peekCtr2) continue;
                                int n = ctr;
                                newPositions[n] = newPositions[n] + (charCtr + 41 - oldPosition);
                            }
                        }
                        charCtr = peekCtr2;
                        updateComment = true;
                    } else if (this.chars[peekCtr2] == '\n') {
                        if (peekCtr2 - charCtr > 41) {
                            for (ctr = 0; ctr < positionCount; ++ctr) {
                                oldPosition = oldPositions[ctr];
                                if (oldPosition <= charCtr + 41) continue;
                                if (oldPosition <= peekCtr2) {
                                    int n = ctr;
                                    newPositions[n] = newPositions[n] - (oldPosition - charCtr - 41);
                                    continue;
                                }
                                int n = ctr;
                                newPositions[n] = newPositions[n] - (peekCtr2 - charCtr - 41);
                            }
                        } else {
                            for (ctr = 0; ctr < positionCount; ++ctr) {
                                if (oldPositions[ctr] < peekCtr2) continue;
                                int n = ctr;
                                newPositions[n] = newPositions[n] + (charCtr + 41 - peekCtr2);
                            }
                        }
                        charCtr = peekCtr2;
                        updateComment = true;
                    }
                    if (!updateComment && charCtr + 41 < this.charCount) {
                        for (peekCtr2 = charCtr + 8; peekCtr2 < charCtr + 41 && this.chars[peekCtr2] != '\n'; ++peekCtr2) {
                        }
                        if (peekCtr2 == charCtr + 41 && this.chars[charCtr + 8] == ' ' && this.chars[charCtr + 9] == ' ' && this.chars[charCtr + 10] == ' ' && this.chars[charCtr + 41 - 1] == ' ') {
                            updateComment = true;
                            charCtr = peekCtr2;
                        }
                    }
                    if (updateComment) {
                        if (address < TVirtualMachine.PC_START.getValue()) {
                            buffer2.delete(0, buffer2.length());
                            buffer2.append("   (");
                            buffer2.append(command.toFormattedBinaryString(false));
                            buffer2.append(", ");
                            buffer2.append(command.toDecimalString(false));
                            buffer2.append(") ");
                            buffer.append(buffer2);
                        } else {
                            buffer2.delete(0, buffer2.length());
                            buffer2.append("   ");
                            buffer2.append(command.toPseudoCodeString(false));
                            while (buffer2.length() < 33) {
                                buffer2.append(' ');
                            }
                            buffer.append(buffer2);
                        }
                    } else {
                        charCtr += 8;
                    }
                } else if (!(this.chars[charCtr] != 'f' && this.chars[charCtr] != 'F' || charCtr + 7 >= this.charCount || this.chars[charCtr + 1] != 'u' && this.chars[charCtr + 1] != 'U' || this.chars[charCtr + 2] != 'n' && this.chars[charCtr + 2] != 'N' || this.chars[charCtr + 3] != 'c' && this.chars[charCtr + 3] != 'C' || this.chars[charCtr + 4] != 't' && this.chars[charCtr + 4] != 'T' || this.chars[charCtr + 5] != 'i' && this.chars[charCtr + 5] != 'I' || this.chars[charCtr + 6] != 'o' && this.chars[charCtr + 6] != 'O' || this.chars[charCtr + 7] != 'n' && this.chars[charCtr + 7] != 'N' || charCtr + 8 != this.charCount && this.chars[charCtr + 8] != ' ' && this.chars[charCtr + 8] != '\n')) {
                    buffer.append("function");
                    charCtr += 8;
                } else if (!(this.chars[charCtr] != 'p' && this.chars[charCtr] != 'P' || charCtr + 6 >= this.charCount || this.chars[charCtr + 1] != 'r' && this.chars[charCtr + 1] != 'R' || this.chars[charCtr + 2] != 'o' && this.chars[charCtr + 2] != 'O' || this.chars[charCtr + 3] != 'g' && this.chars[charCtr + 3] != 'G' || this.chars[charCtr + 4] != 'r' && this.chars[charCtr + 4] != 'R' || this.chars[charCtr + 5] != 'a' && this.chars[charCtr + 5] != 'A' || this.chars[charCtr + 6] != 'm' && this.chars[charCtr + 6] != 'M' || charCtr + 7 != this.charCount && this.chars[charCtr + 7] != ' ' && this.chars[charCtr + 7] != '\n')) {
                    if (buffer.length() == 0) {
                        buffer.append("program");
                        charCtr += 7;
                    } else if (!programEncountered) {
                        buffer2.delete(0, buffer2.length());
                        buffer2.append("program");
                        for (peekCtr = charCtr + 7; peekCtr < this.charCount && this.chars[peekCtr] != '\n'; ++peekCtr) {
                            buffer.append(this.chars[peekCtr]);
                        }
                        buffer2.append('\n');
                        buffer.insert(0, buffer2);
                        int insertedStringLength = buffer2.length();
                        for (int ctr = 0; ctr < positionCount; ++ctr) {
                            if (oldPositions[ctr] == 0) continue;
                            int n = ctr;
                            newPositions[n] = newPositions[n] + insertedStringLength;
                        }
                    }
                    programEncountered = true;
                } else {
                    for (peekCtr = charCtr; peekCtr < this.charCount && this.chars[peekCtr] == ' '; ++peekCtr) {
                    }
                }
                while (charCtr < this.charCount && this.chars[charCtr] != '\n') {
                    buffer.append(this.chars[charCtr]);
                    ++charCtr;
                }
                if (charCtr >= this.charCount) continue;
                buffer.append('\n');
                ++charCtr;
            }
        }
        finally {
            this.readUnlock();
        }
        this.replace(0, Integer.MAX_VALUE, buffer.toString(), false, true, newPositions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stripComments() {
        StringBuffer buffer;
        try {
            this.readLock();
            buffer = new StringBuffer(this.charCount);
            int headerBarIndex = -1;
            int headerBarLength = HEADER_BAR.length();
            for (int lineCtr = 0; lineCtr < this.lineCount && headerBarIndex == -1; ++lineCtr) {
                int charCtr = this.lineOffsets[lineCtr];
                int lineLength = lineCtr == this.lineCount - 1 ? this.charCount - charCtr : this.lineOffsets[lineCtr + 1] - charCtr - 1;
                if (lineLength != headerBarLength) continue;
                boolean match = true;
                for (int ctr = 0; ctr < headerBarLength && match; ++ctr) {
                    if (this.chars[charCtr + ctr] == HEADER_BAR.charAt(ctr)) continue;
                    match = false;
                }
                if (!match) continue;
                headerBarIndex = charCtr;
            }
            if (headerBarIndex == -1) {
                buffer.append("program " + this.title + "\n" + "// Input:    \n" + "// Output:   \n" + "// Remarks:  \n" + HEADER_BAR + "\n" + "\n");
            } else {
                buffer.append(this.chars, 0, headerBarIndex);
                buffer.append("// -----------------------------------------------------------------------------\n\n");
            }
            boolean printedLastLine = true;
            for (int ctr = 0; ctr < 256; ++ctr) {
                if (this.initialMem[ctr].isInitialized()) {
                    if (!printedLastLine) {
                        buffer.append('\n');
                    }
                    buffer.append(TWord.HEX_PAIRS[ctr]);
                    buffer.append(": ");
                    buffer.append(this.initialMem[ctr].toHexString(false));
                    buffer.append('\n');
                    printedLastLine = true;
                    continue;
                }
                printedLastLine = false;
            }
        }
        finally {
            this.readUnlock();
        }
        this.replace(0, Integer.MAX_VALUE, buffer.toString(), false, true, new int[0], true);
    }

    public static class WarningInfoStruct {
        public boolean hasFatalError;
        public int warningCount;
        public final String[] warnings = new String[31];
        public final int[] selectionStart = new int[31];
        public final int[] selectionEnd = new int[31];

        public boolean equals(Object object) {
            if (object == null || !(object instanceof WarningInfoStruct)) {
                return false;
            }
            if (object == this) {
                return true;
            }
            WarningInfoStruct warningInfo = (WarningInfoStruct)object;
            if (warningInfo.hasFatalError != this.hasFatalError || warningInfo.warningCount != this.warningCount) {
                return false;
            }
            for (int ctr = 0; ctr < this.warningCount; ++ctr) {
                if (warningInfo.warnings[ctr].equals(this.warnings[ctr]) && warningInfo.selectionStart[ctr] == this.selectionStart[ctr] && warningInfo.selectionEnd[ctr] == this.selectionEnd[ctr]) continue;
                return false;
            }
            return true;
        }

        public boolean selectionsEqual(WarningInfoStruct warningInfo) {
            if (warningInfo == null) {
                return false;
            }
            if (warningInfo.hasFatalError != this.hasFatalError || warningInfo.warningCount != this.warningCount) {
                return false;
            }
            for (int ctr = 0; ctr < this.warningCount; ++ctr) {
                if (warningInfo.selectionStart[ctr] == this.selectionStart[ctr] && warningInfo.selectionEnd[ctr] == this.selectionEnd[ctr]) continue;
                return false;
            }
            return true;
        }

        public boolean warningsEqual(WarningInfoStruct warningInfo) {
            if (warningInfo == null) {
                return false;
            }
            if (warningInfo.hasFatalError != this.hasFatalError || warningInfo.warningCount != this.warningCount) {
                return false;
            }
            for (int ctr = 0; ctr < this.warningCount; ++ctr) {
                if (warningInfo.warnings[ctr].equals(this.warnings[ctr])) continue;
                return false;
            }
            return true;
        }
    }
}

